/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class SepticRatsTriggeredAbility
extends TriggeredAbilityImpl {
    SepticRatsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostSourceEffect(1, 1, Duration.EndOfTurn));
    }

    private SepticRatsTriggeredAbility(SepticRatsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SepticRatsTriggeredAbility copy() {
        return new SepticRatsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player target;
        return event.getSourceId().equals(this.getSourceId()) && (target = game.getPlayer(event.getTargetId())) != null && target.getCountersCount(CounterType.POISON) > 0;
    }

    public String getRule() {
        return "Whenever {this} attacks, if defending player is poisoned, it gets +1/+1 until end of turn.";
    }
}

