/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.Card;
import mage.cards.s.SeraphDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SeraphEffect
extends OneShotEffect {
    SeraphEffect() {
        super(Outcome.Neutral);
        this.staticText = "put that card onto the battlefield under your control. Sacrifice it when you lose control of {this}";
    }

    private SeraphEffect(SeraphEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card creatureCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || creatureCard == null) {
            return false;
        }
        controller.moveCards(creatureCard, Zone.BATTLEFIELD, source, game, false, false, false, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)creatureCard, (Game)game);
        if (permanent != null) {
            SacrificeTargetEffect effect = new SacrificeTargetEffect();
            effect.setText("Sacrifice this if Seraph leaves the battlefield or its current controller loses control of it.");
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            SeraphDelayedTriggeredAbility dTA = new SeraphDelayedTriggeredAbility((Effect)effect, source.getSourceId());
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)dTA, source);
        }
        return true;
    }

    public SeraphEffect copy() {
        return new SeraphEffect(this);
    }
}

