/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SereneRemembranceEffect
extends OneShotEffect {
    SereneRemembranceEffect() {
        super(Outcome.Benefit);
        this.staticText = "Shuffle {this} and up to three target cards from a single graveyard into their owners' libraries";
    }

    private SereneRemembranceEffect(SereneRemembranceEffect effect) {
        super((OneShotEffect)effect);
    }

    public SereneRemembranceEffect copy() {
        return new SereneRemembranceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player owner;
            CardsImpl cards;
            Card card = game.getCard(source.getSourceId());
            if (card != null) {
                controller.shuffleCardsToLibrary(card, game, source);
            }
            if (!(cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source))).isEmpty() && (owner = game.getPlayer(((Card)cards.getCards(game).iterator().next()).getOwnerId())) != null) {
                owner.shuffleCardsToLibrary((Cards)cards, game, source);
            }
            return true;
        }
        return false;
    }
}

