/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SerpentOfYawningDepthsEffect
extends RestrictionEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    SerpentOfYawningDepthsEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Krakens, Leviathans, Octopuses, and Serpents you control can't be blocked except by Krakens, Leviathans, Octopuses, and Serpents.";
    }

    private SerpentOfYawningDepthsEffect(SerpentOfYawningDepthsEffect effect) {
        super((RestrictionEffect)effect);
    }

    public SerpentOfYawningDepthsEffect copy() {
        return new SerpentOfYawningDepthsEffect(this);
    }

    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return filter.match((Object)blocker, game);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isControlledBy(source.getControllerId()) && filter.match((Object)permanent, game);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.KRAKEN.getPredicate(), SubType.LEVIATHAN.getPredicate(), SubType.OCTOPUS.getPredicate(), SubType.SERPENT.getPredicate()}));
    }
}

