/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SerraBestiaryRuleModifyingEffect
extends ContinuousRuleModifyingEffectImpl {
    SerraBestiaryRuleModifyingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = ", and its activated abilities with {T} in their costs can't be activated";
    }

    private SerraBestiaryRuleModifyingEffect(SerraBestiaryRuleModifyingEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SerraBestiaryRuleModifyingEffect copy() {
        return new SerraBestiaryRuleModifyingEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment == null) {
            return false;
        }
        Permanent enchantedCreature = game.getPermanent(enchantment.getAttachedTo());
        if (enchantedCreature == null) {
            return false;
        }
        MageObject object = game.getObject(event.getSourceId());
        Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
        return ability.isPresent() && object != null && object.isCreature(game) && object.getId().equals(enchantedCreature.getId()) && game.getState().getPlayersInRange(source.getControllerId(), game).contains((Object)event.getPlayerId()) && ((Ability)ability.get()).hasTapCost();
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        return "Enchanted creature can't use its activated abilities that use {tap} in their costs.";
    }
}

