/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.counter.ProliferateEffect;
import mage.constants.Outcome;
import mage.game.Game;

class SerumSnareEffect
extends OneShotEffect {
    SerumSnareEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target nonland permanent to its owner's hand. If that permanent had mana value 3 or less, proliferate. <i>(Choose any number of permanents and/or players, then give each another counter of each kind already there.)</i>";
    }

    private SerumSnareEffect(SerumSnareEffect effect) {
        super((OneShotEffect)effect);
    }

    public SerumSnareEffect copy() {
        return new SerumSnareEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject object = game.getObject(source.getFirstTarget());
        if (object == null) {
            return false;
        }
        new ReturnToHandTargetEffect().apply(game, source);
        int manaValue = object.getManaValue();
        if (manaValue <= 3) {
            new ProliferateEffect().apply(game, source);
        }
        return true;
    }
}

