/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ServantOfTheScaleEffect
extends OneShotEffect {
    ServantOfTheScaleEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "put X +1/+1 counters on target creature you control, where X is the number of +1/+1 counters on {this}";
    }

    private ServantOfTheScaleEffect(ServantOfTheScaleEffect effect) {
        super((OneShotEffect)effect);
    }

    public ServantOfTheScaleEffect copy() {
        return new ServantOfTheScaleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        if (sourcePermanent != null && controller != null && (sourcePermanent.getZoneChangeCounter(game) == source.getStackMomentSourceZCC() || sourcePermanent.getZoneChangeCounter(game) + 1 == source.getStackMomentSourceZCC())) {
            int amount = sourcePermanent.getCounters(game).getCount(CounterType.P1P1);
            if (amount > 0) {
                AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(amount));
                effect.setTargetPointer(this.getTargetPointer().copy());
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

