/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.cards.s.SevinneTheChronoclasmWatcher;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SevinneTheChronoclasmTriggeredAbility
extends SpellCastControllerTriggeredAbility {
    SevinneTheChronoclasmTriggeredAbility() {
        super(null, StaticFilters.FILTER_SPELL_INSTANT_OR_SORCERY, false);
    }

    private SevinneTheChronoclasmTriggeredAbility(SevinneTheChronoclasmTriggeredAbility ability) {
        super((SpellCastControllerTriggeredAbility)ability);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game) || event.getZone() != Zone.GRAVEYARD) {
            return false;
        }
        SevinneTheChronoclasmWatcher watcher = (SevinneTheChronoclasmWatcher)game.getState().getWatcher(SevinneTheChronoclasmWatcher.class);
        if (watcher == null || !watcher.checkFirstSpellThisTurn(this.getControllerId(), event.getTargetId())) {
            return false;
        }
        this.getEffects().clear();
        CopyTargetStackObjectEffect effect = new CopyTargetStackObjectEffect(true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        this.addEffect((Effect)effect);
        return true;
    }

    public String getRule() {
        return "Whenever you cast your first instant or sorcery spell from your graveyard each turn, copy that spell. You may choose new targets for the copy.";
    }

    public SevinneTheChronoclasmTriggeredAbility copy() {
        return new SevinneTheChronoclasmTriggeredAbility(this);
    }
}

