/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.abilities.effects.common.combat.CantBeBlockedTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.BlockingOrBlockedWatcher;

class SewersOfEstarkEffect
extends OneShotEffect {
    SewersOfEstarkEffect() {
        super(Outcome.PreventDamage);
        this.staticText = "Choose target creature. If it's attacking, it can't be blocked this turn. If it's blocking, prevent all combat damage that would be dealt this combat by it and each creature it's blocking.";
    }

    private SewersOfEstarkEffect(SewersOfEstarkEffect effect) {
        super((OneShotEffect)effect);
    }

    public SewersOfEstarkEffect copy() {
        return new SewersOfEstarkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature == null) {
            return false;
        }
        if (creature.isAttacking()) {
            ContinuousEffect effect = new CantBeBlockedTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
            game.addEffect(effect, source);
            return true;
        }
        if (creature.getBlocking() > 0) {
            ArrayList<Permanent> creatures = new ArrayList<Permanent>();
            creatures.add(creature);
            for (Permanent blockedByTarget : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_ATTACKING_CREATURE, source.getControllerId(), game)) {
                if (!BlockingOrBlockedWatcher.check((Permanent)blockedByTarget, (Permanent)creature, (Game)game)) continue;
                creatures.add(blockedByTarget);
            }
            ContinuousEffect effect = new PreventDamageByTargetEffect(Duration.EndOfCombat, true).setTargetPointer((TargetPointer)new FixedTargets(creatures, game));
            game.addEffect(effect, source);
            return true;
        }
        return false;
    }
}

