/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DealsDamageSourceTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.AttachedToSourcePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class ShacklesOfTreachery
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent(SubType.EQUIPMENT, "Equipment attached to it");

    public ShacklesOfTreachery(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{R}");
        this.getSpellAbility().addEffect((Effect)new GainControlTargetEffect(Duration.EndOfTurn));
        this.getSpellAbility().addEffect((Effect)new UntapTargetEffect().setText("Untap that creature"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setText("Until end of turn, it gains haste"));
        DealsDamageSourceTriggeredAbility ability = new DealsDamageSourceTriggeredAbility((Effect)new DestroyTargetEffect());
        ability.addTarget((Target)new TargetPermanent(filter));
        ability.setTriggerPhrase("Whenever this creature deals damage, ");
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)ability, Duration.EndOfTurn).setText("and \"Whenever this creature deals damage, destroy target Equipment attached to it.\""));
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
    }

    private ShacklesOfTreachery(ShacklesOfTreachery card) {
        super((CardImpl)card);
    }

    public ShacklesOfTreachery copy() {
        return new ShacklesOfTreachery(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AttachedToSourcePredicate.instance);
    }
}

