/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShadesBreathSetColorEffect
extends ContinuousEffectImpl {
    ShadesBreathSetColorEffect() {
        super(Duration.EndOfTurn, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Until end of turn, each creature you control becomes a black";
    }

    private ShadesBreathSetColorEffect(ShadesBreathSetColorEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
        for (Permanent permanent : permanents) {
            if (permanent == null) continue;
            permanent.getColor(game).setColor(ObjectColor.BLACK);
        }
        return true;
    }

    public ShadesBreathSetColorEffect copy() {
        return new ShadesBreathSetColorEffect(this);
    }
}

