/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.ShadowKinApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;
import mage.util.CardUtil;
import mage.util.functions.CopyApplier;

class ShadowKinEffect
extends OneShotEffect {
    ShadowKinEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player mills three cards. You may exile a creature card from among the cards milled this way. If you do, {this} becomes a copy of that card, except it has this ability";
    }

    private ShadowKinEffect(ShadowKinEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShadowKinEffect copy() {
        return new ShadowKinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.addAll((Collection)player.millCards(3, source, game));
        }
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withNotTarget(true);
        controller.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (card == null || sourcePermanent == null) {
            return true;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        PermanentCard blueprint = new PermanentCard(CardUtil.getDefaultCardSideForBattlefield((Game)game, (Card)card), source.getControllerId(), game);
        blueprint.assignNewId();
        ShadowKinApplier applier = new ShadowKinApplier();
        applier.apply(game, (MageObject)blueprint, source, sourcePermanent.getId());
        CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)blueprint, sourcePermanent.getId());
        copyEffect.setApplier((CopyApplier)applier);
        Ability newAbility = source.copy();
        copyEffect.init(newAbility, game);
        game.addEffect((ContinuousEffect)copyEffect, newAbility);
        return true;
    }
}

