/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShadowPuppeteersContinousEffect
extends ContinuousEffectImpl {
    ShadowPuppeteersContinousEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "have it become a red Dragon with base power and toughness 4/4 in addition to its other colors and types until end of turn";
    }

    private ShadowPuppeteersContinousEffect(ShadowPuppeteersContinousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ShadowPuppeteersContinousEffect copy() {
        return new ShadowPuppeteersContinousEffect(this);
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.addSubType(game, new SubType[]{SubType.DRAGON});
                break;
            }
            case ColorChangingEffects_5: {
                permanent.getColor(game).setRed(true);
                break;
            }
            case PTChangingEffects_7: {
                permanent.getToughness().setModifiedBaseValue(4);
                permanent.getPower().setModifiedBaseValue(4);
            }
        }
        return true;
    }
}

