/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.common.PreventNextDamageFromChosenSourceEffect;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;

enum ShadowbanePreventionApplier implements PreventNextDamageFromChosenSourceEffect.ApplierOnPrevention
{
    instance;


    public String getText() {
        return "If damage from a black source is prevented this way, you gain that much life";
    }

    public boolean apply(PreventionEffectData data, Target target, GameEvent event, Ability source, Game game) {
        if (data == null || data.getPreventedDamage() <= 0) {
            return false;
        }
        MageObject sourceObject = game.getObject(target.getFirstTarget());
        if (!sourceObject.getColor(game).isBlack()) {
            return false;
        }
        int prevented = data.getPreventedDamage();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.gainLife(prevented, game, source);
        return true;
    }
}

