/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.AmassEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShagratLootBearerEffect
extends OneShotEffect {
    ShagratLootBearerEffect() {
        super(Outcome.Benefit);
        this.staticText = "attach up to one target Equipment to it. Then amass Orcs X, where X is the number of Equipment attached to {this}";
    }

    private ShagratLootBearerEffect(ShagratLootBearerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShagratLootBearerEffect copy() {
        return new ShagratLootBearerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.addAttachment(this.getTargetPointer().getFirst(game, source), source, game);
        }
        int count = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).filter(Objects::nonNull).map(Permanent::getAttachments).map(Collection::stream).map(s -> s.map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(p -> p.hasSubtype(SubType.EQUIPMENT, game)).mapToInt(x -> 1).sum()).orElse(0);
        AmassEffect.doAmass((int)count, (SubType)SubType.ORC, (Game)game, (Ability)source);
        return true;
    }
}

