/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class ShalaiAndHallarTriggeredAbility
extends TriggeredAbilityImpl {
    ShalaiAndHallarTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)SavedDamageValue.MUCH));
        this.addTarget((Target)new TargetOpponent());
    }

    private ShalaiAndHallarTriggeredAbility(ShalaiAndHallarTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ShalaiAndHallarTriggeredAbility copy() {
        return new ShalaiAndHallarTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getData().equals(CounterType.P1P1.getName()) || event.getAmount() < 1) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
        }
        if (permanent == null || !permanent.isControlledBy(this.getControllerId()) || !permanent.isCreature(game)) {
            return false;
        }
        this.getEffects().setValue("damage", (Object)event.getAmount());
        return true;
    }

    public String getRule() {
        return "Whenever one or more +1/+1 counters are put on a creature you control, {this} deals that much damage to target opponent.";
    }
}

