/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ControllerGainedLifeCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.ManaUtil;

class ShannaPurifyingBladeEffect
extends OneShotEffect {
    ShannaPurifyingBladeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}. If you do, draw X cards. X can't be greater than the amount of life you gained this turn";
    }

    private ShannaPurifyingBladeEffect(ShannaPurifyingBladeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShannaPurifyingBladeEffect copy() {
        return new ShannaPurifyingBladeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int lifeGained = ControllerGainedLifeCount.instance.calculate(game, source, (Effect)this);
        if (lifeGained < 1) {
            return false;
        }
        int count = ManaUtil.playerPaysXGenericMana((boolean)true, (String)"Shanna, Purifying Blade", (Player)player, (Ability)source, (Game)game, (int)lifeGained);
        return count > 0 && player.drawCards(count, source, game) > 0;
    }
}

