/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SharaeOfNumbingDepthsTriggeredAbility
extends TriggeredAbilityImpl {
    SharaeOfNumbingDepthsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.setTriggersLimitEachTurn(1);
        this.setTriggerPhrase("Whenever you tap one or more untapped creatures your opponents control, ");
    }

    private SharaeOfNumbingDepthsTriggeredAbility(SharaeOfNumbingDepthsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SharaeOfNumbingDepthsTriggeredAbility copy() {
        return new SharaeOfNumbingDepthsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && this.isControlledBy(event.getPlayerId()) && StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE.match(permanent, this.getControllerId(), (Ability)this, game);
    }
}

