/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ShardOfTheNightbringerEffect
extends OneShotEffect {
    ShardOfTheNightbringerEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent loses half their life, rounded up. You gain life equal to the life lost this way";
    }

    private ShardOfTheNightbringerEffect(ShardOfTheNightbringerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShardOfTheNightbringerEffect copy() {
        return new ShardOfTheNightbringerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        int lifeLost = opponent.loseLife(opponent.getLife() / 2 + opponent.getLife() % 2, game, source, false);
        if (lifeLost < 1) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        return controller == null || controller.gainLife(lifeLost, game, source) > 0;
    }
}

