/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class ShardOfTheVoidDragonTriggeredAbility
extends TriggeredAbilityImpl {
    ShardOfTheVoidDragonTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(2)));
        this.setTriggerPhrase("Whenever an artifact is put into a graveyard from the battlefield or is put into exile from the battlefield, ");
        this.withFlavorWord("Matter Absorption");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private ShardOfTheVoidDragonTriggeredAbility(ShardOfTheVoidDragonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ShardOfTheVoidDragonTriggeredAbility copy() {
        return new ShardOfTheVoidDragonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getTarget() != null && zEvent.getTarget().isArtifact(game) && zEvent.getFromZone() == Zone.BATTLEFIELD && (zEvent.getToZone() == Zone.GRAVEYARD || zEvent.getToZone() == Zone.EXILED);
    }
}

