/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.s.ShareTheSpoilsSpendAnyManaEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ShareTheSpoilsExileCardFromEveryoneEffect
extends OneShotEffect {
    ShareTheSpoilsExileCardFromEveryoneEffect() {
        super(Outcome.Exile);
    }

    private ShareTheSpoilsExileCardFromEveryoneEffect(ShareTheSpoilsExileCardFromEveryoneEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        if (source == null) {
            return false;
        }
        PlayerList players = game.getState().getPlayersInRange(source.getControllerId(), game);
        for (UUID playerId : players) {
            boolean moved;
            Card topLibraryCard;
            Player player = game.getPlayer(playerId);
            if (player == null || (topLibraryCard = player.getLibrary().getFromTop(game)) == null || !(moved = player.moveCardsToExile(topLibraryCard, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source)))) continue;
            ShareTheSpoilsSpendAnyManaEffect effect = new ShareTheSpoilsSpendAnyManaEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(topLibraryCard, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }

    public ShareTheSpoilsExileCardFromEveryoneEffect copy() {
        return new ShareTheSpoilsExileCardFromEveryoneEffect(this);
    }
}

