/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.s.SharedFate;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPlayer;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.util.CardUtil;

class SharedFateReplacementEffect
extends ReplacementEffectImpl {
    SharedFateReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If a player would draw a card, that player exiles the top card of one of their opponents' libraries face down instead";
    }

    private SharedFateReplacementEffect(SharedFateReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SharedFateReplacementEffect copy() {
        return new SharedFateReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player playerToDraw = game.getPlayer(event.getPlayerId());
        Player controller = game.getPlayer(source.getControllerId());
        PlayerList playersInControllerRange = game.getState().getPlayersInRange(source.getControllerId(), game);
        if (sourcePermanent == null || playerToDraw == null || controller == null || !playersInControllerRange.contains((Object)playerToDraw.getId())) {
            return false;
        }
        PlayerList playersInPlayerRange = game.getState().getPlayersInRange(playerToDraw.getId(), game);
        FilterPlayer filter = new FilterPlayer("opponent");
        ArrayList<PlayerIdPredicate> opponentPredicates = new ArrayList<PlayerIdPredicate>();
        for (UUID opponentId : game.getOpponents(playerToDraw.getId())) {
            if (!playersInPlayerRange.contains((Object)opponentId) || !playersInControllerRange.contains((Object)opponentId)) continue;
            opponentPredicates.add(new PlayerIdPredicate(opponentId));
        }
        filter.add(Predicates.or(opponentPredicates));
        TargetPlayer target = new TargetPlayer(1, 1, true, filter);
        if (!playerToDraw.choose(Outcome.DrawCard, (Target)target, source, game)) {
            return false;
        }
        Player chosenPlayer = game.getPlayer(target.getFirstTarget());
        if (chosenPlayer == null) {
            return false;
        }
        game.informPlayers(playerToDraw.getLogName() + " chose to exile from " + chosenPlayer.getLogName() + "' library.");
        Card card = chosenPlayer.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((String)SharedFate.prepareExileKey(game, source, sourcePermanent, playerToDraw.getId()), (Game)game);
        String exileName = sourcePermanent.getIdName() + "-" + sourcePermanent.getZoneChangeCounter(game) + " (" + playerToDraw.getName() + ')';
        playerToDraw.moveCardsToExile(card, source, game, false, exileId, exileName);
        card.setFaceDown(true, game);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }
}

