/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShatteredEgoEffect
extends OneShotEffect {
    ShatteredEgoEffect() {
        super(Outcome.Benefit);
        this.staticText = "put enchanted creature into its owner's library third from the top";
    }

    private ShatteredEgoEffect(ShatteredEgoEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShatteredEgoEffect copy() {
        return new ShatteredEgoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent aura = source.getSourcePermanentOrLKI(game);
        if (player == null || aura == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(aura.getAttachedTo());
        return permanent != null && player.putCardOnTopXOfLibrary((Card)permanent, game, source, 3, true);
    }
}

