/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.ShroudAbility;
import mage.abilities.keyword.WardAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShayCormacEffect
extends ContinuousEffectImpl {
    ShayCormacEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.staticText = "permanents your opponents control lose hexproof, indestructible, protection, shroud, and ward until end of turn";
    }

    private ShayCormacEffect(ShayCormacEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ShayCormacEffect copy() {
        return new ShayCormacEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        game.getBattlefield().getActivePermanents(StaticFilters.FILTER_OPPONENTS_PERMANENT, source.getControllerId(), source, game).stream().map(permanent -> new MageObjectReference((MageObject)permanent, game)).forEach(this.affectedObjectList::add);
    }

    public boolean apply(Game game, Ability source) {
        for (MageObjectReference mor : this.affectedObjectList) {
            Permanent permanent = mor.getPermanent(game);
            if (permanent == null) continue;
            permanent.getAbilities(game).removeIf(HexproofBaseAbility.class::isInstance);
            permanent.removeAbility((Ability)IndestructibleAbility.getInstance(), source.getSourceId(), game);
            permanent.getAbilities(game).removeIf(ProtectionAbility.class::isInstance);
            permanent.removeAbility((Ability)ShroudAbility.getInstance(), source.getSourceId(), game);
            permanent.getAbilities(game).removeIf(WardAbility.class::isInstance);
        }
        return true;
    }
}

