/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.token.FoodAbility;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShelobChildOfUngoliantEffect
extends OneShotEffect {
    ShelobChildOfUngoliantEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a token that's a copy of that creature, except it's a Food artifact with \"{2}, {T}, Sacrifice this artifact: You gain 3 life,\" and it loses all other card types.";
    }

    private ShelobChildOfUngoliantEffect(ShelobChildOfUngoliantEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShelobChildOfUngoliantEffect copy() {
        return new ShelobChildOfUngoliantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent copyFrom = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller == null || copyFrom == null) {
            return false;
        }
        return new CreateTokenCopyTargetEffect().setSavedPermanent(copyFrom).setPermanentModifier(token -> {
            token.removeAllCardTypes();
            token.getSubtype().retainAll((Collection)SubType.getArtifactTypes());
            token.addCardType(new CardType[]{CardType.ARTIFACT});
            token.addSubType(new SubType[]{SubType.FOOD});
            token.addAbility((Ability)new FoodAbility());
        }).apply(game, source);
    }
}

