/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeAllCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.EnterBattlefieldPayCostOrPutGraveyardEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.mana.ColorlessManaAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;

public final class ShelteredValley
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("permanent named Sheltered Valley");
    private static final Condition condition;

    public ShelteredValley(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        this.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new EnterBattlefieldPayCostOrPutGraveyardEffect((Cost)new SacrificeAllCost(filter)).setText("If {this} would enter, instead sacrifice each other permanent named Sheltered Valley you control, then put {this} onto the battlefield.")));
        this.addAbility((Ability)new BeginningOfUpkeepTriggeredAbility((Effect)new GainLifeEffect(1)).withInterveningIf(condition));
        this.addAbility((Ability)new ColorlessManaAbility());
    }

    private ShelteredValley(ShelteredValley card) {
        super((CardImpl)card);
    }

    public ShelteredValley copy() {
        return new ShelteredValley(this);
    }

    static {
        filter.add((Predicate)new NamePredicate("Sheltered Valley"));
        condition = new PermanentsOnTheBattlefieldCondition((FilterPermanent)new FilterControlledLandPermanent("you control three or fewer lands"), ComparisonType.FEWER_THAN, 4);
    }
}

