/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;

class ShikoAndNarsetEffect
extends OneShotEffect {
    public ShikoAndNarsetEffect() {
        super(Outcome.Copy);
        this.staticText = "copy that spell if it targets a permanent or player, and you may choose new targets for the copy. If you don't copy a spell this way, draw a card.";
    }

    private ShikoAndNarsetEffect(ShikoAndNarsetEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShikoAndNarsetEffect copy() {
        return new ShikoAndNarsetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (controller == null || spell == null) {
            return false;
        }
        boolean targetsPermOrPlayer = spell.getStackAbility().getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).anyMatch(uuid -> game.getPlayer(uuid) != null || game.getPermanent(uuid) != null);
        if (targetsPermOrPlayer) {
            boolean newTargets = controller.chooseUse(Outcome.Neutral, "Choose new targets for the copy of " + spell.getLogName() + "?", source, game);
            spell.createCopyOnStack(game, source, source.getControllerId(), newTargets);
        } else {
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

