/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.common.search.SearchTargetGraveyardHandLibraryForCardNameAndExileEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class ShimianSpecterEffect
extends SearchTargetGraveyardHandLibraryForCardNameAndExileEffect {
    private static final FilterCard filter = new FilterCard("nonland card");

    public ShimianSpecterEffect() {
        super(false, "that player's", "all cards with the same name as that card");
        this.staticText = "that player reveals their hand. You choose a nonland card from it. Search that player's graveyard, hand, and library for all cards with the same name as that card and exile them. Then that player shuffles";
    }

    private ShimianSpecterEffect(ShimianSpecterEffect effect) {
        super((SearchTargetGraveyardHandLibraryForCardNameAndExileEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (targetPlayer != null && sourceObject != null && controller != null) {
            targetPlayer.revealCards(sourceObject.getName(), targetPlayer.getHand(), game);
            TargetCard target = new TargetCard(Zone.HAND, (FilterCard)new FilterNonlandCard());
            if (controller.choose(Outcome.Benefit, targetPlayer.getHand(), target, source, game)) {
                return this.applySearchAndExile(game, source, CardUtil.getCardNameForSameNameSearch((Card)game.getCard(target.getFirstTarget())), this.getTargetPointer().getFirst(game, source));
            }
        }
        return false;
    }

    public ShimianSpecterEffect copy() {
        return new ShimianSpecterEffect(this);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
    }
}

