/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class ShinryuTranscendentRivalEffect
extends ReplacementEffectImpl {
    ShinryuTranscendentRivalEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as this creature transforms into {this}, choose an opponent";
    }

    private ShinryuTranscendentRivalEffect(ShinryuTranscendentRivalEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ShinryuTranscendentRivalEffect copy() {
        return new ShinryuTranscendentRivalEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller == null || permanent == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent(true);
        controller.choose(this.outcome, (Target)target, source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        game.informPlayers(permanent.getName() + ": " + controller.getLogName() + " has chosen " + opponent.getLogName());
        game.getState().setValue(permanent.getId() + "_" + permanent.getZoneChangeCounter(game) + "_opponent", (Object)opponent.getId());
        permanent.addInfo("chosen opponent", CardUtil.addToolTipMarkTags((String)("Chosen Opponent " + opponent.getLogName())), game);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRANSFORMING;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getTargetId()) && source.getSourcePermanentIfItStillExists(game) != null;
    }
}

