/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class ShorelineScoutWatcher
extends Watcher {
    private final Set<UUID> islandSet = new HashSet<UUID>();
    private final Map<UUID, Set<MageObjectReference>> merfolkMap = new HashMap<UUID, Set<MageObjectReference>>();
    private static final Set<MageObjectReference> emptySet = Collections.unmodifiableSet(new HashSet());

    ShorelineScoutWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent == null) {
            return;
        }
        if (permanent.hasSubtype(SubType.ISLAND, game)) {
            this.islandSet.add(permanent.getControllerId());
        } else if (permanent.hasSubtype(SubType.MERFOLK, game)) {
            this.merfolkMap.computeIfAbsent(permanent.getControllerId(), x -> new HashSet()).add(new MageObjectReference((MageObject)permanent, game));
        }
    }

    public void reset() {
        super.reset();
        this.islandSet.clear();
        this.merfolkMap.clear();
    }

    static boolean checkPlayer(Ability source, Game game) {
        ShorelineScoutWatcher watcher = (ShorelineScoutWatcher)game.getState().getWatcher(ShorelineScoutWatcher.class);
        return watcher.islandSet.contains(source.getControllerId()) || watcher.merfolkMap.getOrDefault(source.getControllerId(), emptySet).stream().anyMatch(mor -> !mor.refersTo(source.getSourceObject(game), game));
    }
}

