/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.InstantAndSorceryCastThisTurn;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.watchers.common.SpellsCastWatcher;

class ShowOfConfidenceEffect
extends OneShotEffect {
    ShowOfConfidenceEffect() {
        super(Outcome.Benefit);
        this.staticText = "copy it for each other instant and sorcery spell you've cast this turn. You may choose new targets for the copies";
    }

    private ShowOfConfidenceEffect(ShowOfConfidenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShowOfConfidenceEffect copy() {
        return new ShowOfConfidenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = (Spell)this.getValue("spellCast");
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (spell == null || watcher == null) {
            return false;
        }
        int copies = InstantAndSorceryCastThisTurn.YOU.calculate(game, source, (Effect)this) - 1;
        if (copies > 0) {
            spell.createCopyOnStack(game, source, source.getControllerId(), true, copies);
        }
        return true;
    }
}

