/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.s.ShowdownOfTheSkaldsMayPlayEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ShowdownOfTheSkaldsEffect
extends OneShotEffect {
    ShowdownOfTheSkaldsEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top four cards of your library. Until the end of your next turn, you may play those cards";
    }

    private ShowdownOfTheSkaldsEffect(ShowdownOfTheSkaldsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShowdownOfTheSkaldsEffect copy() {
        return new ShowdownOfTheSkaldsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Set cards = controller.getLibrary().getTopCards(game, 4);
            Card sourceCard = game.getCard(source.getSourceId());
            controller.moveCardsToExile(cards, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), sourceCard != null ? sourceCard.getIdName() : "");
            for (Card card : cards) {
                ShowdownOfTheSkaldsMayPlayEffect effect = new ShowdownOfTheSkaldsMayPlayEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

