/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class ShroudedLoreEffect
extends OneShotEffect {
    ShroudedLoreEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent chooses a card in your graveyard. You may pay {B}. If you do, repeat this process except that opponent can't choose a card already chosen for {this}. Then put the last chosen card into your hand.";
    }

    private ShroudedLoreEffect(ShroudedLoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShroudedLoreEffect copy() {
        return new ShroudedLoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (you != null && opponent != null) {
            FilterCard filter = new FilterCard();
            filter.add((Predicate)new OwnerIdPredicate(you.getId()));
            ManaCostsImpl cost = new ManaCostsImpl("{B}");
            Card card = null;
            boolean done = false;
            do {
                TargetCardInGraveyard chosenCard = new TargetCardInGraveyard(filter);
                chosenCard.withNotTarget(true);
                if (chosenCard.canChoose(opponent.getId(), source, game)) {
                    opponent.chooseTarget(Outcome.ReturnToHand, (Target)chosenCard, source, game);
                    card = game.getCard(chosenCard.getFirstTarget());
                    if (card != null) {
                        filter.add(Predicates.not((Predicate)new CardIdPredicate(card.getId())));
                        game.informPlayers("Shrouded Lore: " + opponent.getLogName() + " has chosen " + card.getLogName());
                    }
                } else {
                    done = true;
                }
                if (done) continue;
                done = true;
                if (!cost.canPay(source, source, you.getId(), game) || !you.chooseUse(Outcome.Benefit, "Pay {B} to choose a different card ?", source, game)) continue;
                cost.clearPaid();
                if (!cost.pay(source, game, source, you.getId(), false, null)) continue;
                done = false;
            } while (!done);
            if (card != null) {
                CardsImpl cardsToHand = new CardsImpl();
                cardsToHand.add(card);
                you.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }
}

