/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ShurikenEffect
extends OneShotEffect {
    ShurikenEffect() {
        super(Outcome.Benefit);
    }

    private ShurikenEffect(ShurikenEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShurikenEffect copy() {
        return new ShurikenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object object = this.getValue("attachedPermanent");
        Player player = game.getPlayer(source.getControllerId());
        Permanent targetedPermanent = game.getPermanent(source.getFirstTarget());
        if (!(object instanceof Permanent) || player == null || targetedPermanent == null) {
            return false;
        }
        Permanent equipment = (Permanent)object;
        targetedPermanent.damage(2, equipment.getId(), source, game);
        Permanent attached = source.getSourcePermanentOrLKI(game);
        if (attached == null || attached.hasSubtype(SubType.NINJA, game)) {
            return true;
        }
        game.addEffect(new GainControlTargetEffect(Duration.Custom, true, targetedPermanent.getControllerId()).setTargetPointer((TargetPointer)new FixedTarget(equipment, game)), source);
        return true;
    }

    public String getText(Mode mode) {
        String name = "Shuriken";
        Object object = this.getValue("attachedPermanent");
        if (object instanceof Permanent) {
            name = ((Permanent)object).getName();
        }
        return name + " deals 2 damage to target creature. That creature's controller gains control of " + name + " unless it was unattached from a Ninja.";
    }
}

