/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SibyllineSoothsayerEffect
extends OneShotEffect {
    SibyllineSoothsayerEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal cards from the top of your library until you reveal a nonland card with mana value 3 or greater. Exile that card with three time counters on it. If it doesn't have suspend, it gains suspend. Put the rest of the revealed cards on the bottom of your library in a random order.";
    }

    private SibyllineSoothsayerEffect(SibyllineSoothsayerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SibyllineSoothsayerEffect copy() {
        return new SibyllineSoothsayerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.getLibrary().hasCards()) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (card.isLand(game) || card.getManaValue() < 3) continue;
            player.revealCards(source, (Cards)cards, game);
            player.moveCards(card, Zone.EXILED, source, game);
            SuspendAbility.addTimeCountersAndSuspend((Card)card, (int)3, (Ability)source, (Game)game);
            break;
        }
        cards.retainZone(Zone.LIBRARY, game);
        if (!cards.isEmpty()) {
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }
}

