/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieToken;

class SidisiBroodTyrantTriggeredAbility
extends TriggeredAbilityImpl {
    public SidisiBroodTyrantTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new ZombieToken()), false);
    }

    private SidisiBroodTyrantTriggeredAbility(SidisiBroodTyrantTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent != null && Zone.LIBRARY == zEvent.getFromZone() && Zone.GRAVEYARD == zEvent.getToZone() && zEvent.getCards() != null) {
            for (Card card : zEvent.getCards()) {
                UUID cardOwnerId;
                if (card == null || (cardOwnerId = card.getOwnerId()) == null || !card.isOwnedBy(this.getControllerId()) || !card.isCreature(game)) continue;
                return true;
            }
        }
        return false;
    }

    public SidisiBroodTyrantTriggeredAbility copy() {
        return new SidisiBroodTyrantTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more creature cards are put into your graveyard from your library, create a 2/2 black Zombie creature token.";
    }
}

