/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.s.SiegeDragonDamageEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;

class SiegeDragonAttacksTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("wall");

    public SiegeDragonAttacksTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SiegeDragonDamageEffect());
    }

    private SiegeDragonAttacksTriggeredAbility(SiegeDragonAttacksTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SiegeDragonAttacksTriggeredAbility copy() {
        return new SiegeDragonAttacksTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getSourceId().equals(this.getSourceId());
    }

    public boolean checkInterveningIfClause(Game game) {
        UUID defendingPlayerId = game.getCombat().getDefendingPlayerId(this.getSourceId(), game);
        return defendingPlayerId != null && game.getBattlefield().countAll((FilterPermanent)filter, defendingPlayerId, game) < 1;
    }

    public String getRule() {
        return "Whenever {this} attacks, if defending player controls no Walls, it deals 2 damage to each creature without flying that player controls.";
    }

    static {
        filter.add((Predicate)SubType.WALL.getPredicate());
    }
}

