/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SifterWurmEffect
extends OneShotEffect {
    SifterWurmEffect() {
        super(Outcome.DrawCard);
        this.staticText = "scry 3, then reveal the top card of your library. You gain life equal to that card's mana value.";
    }

    private SifterWurmEffect(SifterWurmEffect effect) {
        super((OneShotEffect)effect);
    }

    public SifterWurmEffect copy() {
        return new SifterWurmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            controller.scry(3, source, game);
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                CardsImpl cards = new CardsImpl();
                cards.add(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                controller.gainLife(card.getManaValue(), game, source);
            }
            return true;
        }
        return false;
    }
}

