/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturesWithDifferentPowers;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class SigardianZealotEffect
extends OneShotEffect {
    SigardianZealotEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose any number of creatures with different powers. Each of them gets +X/+X and gains vigilance until end of turn, where X is {this}'s power";
    }

    private SigardianZealotEffect(SigardianZealotEffect effect) {
        super((OneShotEffect)effect);
    }

    public SigardianZealotEffect copy() {
        return new SigardianZealotEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        if (power == 0) {
            return false;
        }
        TargetCreaturesWithDifferentPowers target = new TargetCreaturesWithDifferentPowers();
        player.choose(this.outcome, (Target)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        if (cards.isEmpty()) {
            return false;
        }
        game.addEffect(new BoostTargetEffect(power, power).setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game)), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game)), source);
        return true;
    }
}

