/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SilentArbiterBlockRestrictionEffect
extends RestrictionEffect {
    SilentArbiterBlockRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "No more than one creature can block each combat";
    }

    private SilentArbiterBlockRestrictionEffect(SilentArbiterBlockRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public SilentArbiterBlockRestrictionEffect copy() {
        return new SilentArbiterBlockRestrictionEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return true;
    }

    public boolean canBlock(Permanent attacker, Permanent newBlocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        for (UUID creatureId : game.getCombat().getBlockers()) {
            Permanent existingBlocker = game.getPermanent(creatureId);
            if (!game.getPlayer(existingBlocker.getControllerId()).hasOpponent(attacker.getControllerId(), game) || !existingBlocker.isControlledBy(newBlocker.getControllerId())) continue;
            return false;
        }
        return true;
    }
}

