/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SilentBladeOniEffect
extends OneShotEffect {
    SilentBladeOniEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "look at that player's hand. You may cast a spell from among those cards without paying its mana cost";
    }

    private SilentBladeOniEffect(SilentBladeOniEffect effect) {
        super((OneShotEffect)effect);
    }

    public SilentBladeOniEffect copy() {
        return new SilentBladeOniEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        controller.lookAtCards(opponent.getName(), opponent.getHand(), game);
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)opponent.getHand()), (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
    }
}

