/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.s.SilumgarScavengerExploitedWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class SilumgarScavengerBoostEffect
extends OneShotEffect {
    SilumgarScavengerBoostEffect() {
        super(Outcome.AddAbility);
        this.staticText = "It gains haste until end of turn if it exploited that creature";
    }

    private SilumgarScavengerBoostEffect(SilumgarScavengerBoostEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        UUID diesPermanent = this.getTargetPointer().getFirst(game, source);
        SilumgarScavengerExploitedWatcher watcher = (SilumgarScavengerExploitedWatcher)game.getState().getWatcher(SilumgarScavengerExploitedWatcher.class);
        if (watcher != null && watcher.isPermanentExploited(game, diesPermanent)) {
            GainAbilitySourceEffect effect = new GainAbilitySourceEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }

    public SilumgarScavengerBoostEffect copy() {
        return new SilumgarScavengerBoostEffect(this);
    }
}

