/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetCreaturePermanent;
import mage.target.common.TargetOpponent;

public final class SilverquillCommand
extends CardImpl {
    private static final FilterCard filter = new FilterCreatureCard("creature card with mana value 2 or less from your graveyard");

    public SilverquillCommand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{W}{B}");
        this.getSpellAbility().getModes().setMinModes(2);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(3, 3).setText("target creature gets +3/+3"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn).setText("and gains flying until end of turn"));
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        Mode mode = new Mode((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect());
        mode.addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new DrawCardTargetEffect(1));
        mode.addEffect((Effect)new LoseLifeTargetEffect(1).setText("and loses 1 life"));
        mode.addTarget((Target)new TargetPlayer());
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, 1, "Target opponent"));
        mode.addTarget((Target)new TargetOpponent());
        this.getSpellAbility().addMode(mode);
    }

    private SilverquillCommand(SilverquillCommand card) {
        super((CardImpl)card);
    }

    public SilverquillCommand copy() {
        return new SilverquillCommand(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

