/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.RandomUtil;

class SinSpirasPunishmentEffect
extends OneShotEffect {
    SinSpirasPunishmentEffect() {
        super(Outcome.Exile);
        this.staticText = "exile a permanent card from your graveyard at random, then create a tapped token that's a copy of that card. If the exiled card is a land card, repeat this process";
    }

    private SinSpirasPunishmentEffect(SinSpirasPunishmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public SinSpirasPunishmentEffect copy() {
        return new SinSpirasPunishmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        boolean repeat = true;
        while (repeat) {
            Card card = (Card)RandomUtil.randomFromCollection((Collection)player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_PERMANENT, game));
            if (card == null) {
                return true;
            }
            player.moveCards(card, Zone.EXILED, source, game);
            game.processAction();
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, 1, true, false);
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            effect.apply(game, source);
            game.processAction();
            repeat = card.getCardType(game).contains(CardType.LAND);
        }
        return true;
    }
}

