/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.Target;
import mage.target.TargetStackObject;
import mage.target.Targets;

class SirenStormtamerTarget
extends TargetStackObject {
    public SirenStormtamerTarget() {
        this.withTargetName("spell or ability that targets you or a creature you control");
    }

    private SirenStormtamerTarget(SirenStormtamerTarget target) {
        super((TargetStackObject)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        HashSet<UUID> targetsMe = new HashSet<UUID>();
        for (StackObject stackObject : game.getStack()) {
            Targets objectTargets = stackObject.getStackAbility().getTargets();
            for (Target target : objectTargets) {
                for (UUID targetId : target.getTargets()) {
                    Permanent targetedPermanent = game.getPermanentOrLKIBattlefield(targetId);
                    if (targetedPermanent != null && targetedPermanent.isControlledBy(sourceControllerId) && targetedPermanent.isCreature(game)) {
                        targetsMe.add(stackObject.getId());
                    }
                    if (!sourceControllerId.equals(targetId)) continue;
                    targetsMe.add(stackObject.getId());
                }
            }
        }
        possibleTargets.removeIf(id -> !targetsMe.contains(id));
        return possibleTargets;
    }

    public SirenStormtamerTarget copy() {
        return new SirenStormtamerTarget(this);
    }
}

