/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.AttackedThisTurnWatcher;

class SirensCallDestroyEffect
extends OneShotEffect {
    SirensCallDestroyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all non-Wall creatures that player controls that didn't attack this turn. Ignore this effect for each creature the player didn't control continuously since the beginning of the turn";
    }

    private SirensCallDestroyEffect(SirensCallDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public SirensCallDestroyEffect copy() {
        return new SirensCallDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player != null) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(player.getId())) {
                AttackedThisTurnWatcher watcher;
                if (!permanent.isCreature(game) || permanent.hasSubtype(SubType.WALL, game) || (watcher = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class)) != null && watcher.getAttackedThisTurnCreatures().contains(new MageObjectReference((MageObject)permanent, game)) || !permanent.wasControlledFromStartOfControllerTurn()) continue;
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

