/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SisterHospitallerEffect
extends OneShotEffect {
    SisterHospitallerEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature card from your graveyard to the battlefield. You gain life equal to its mana value";
    }

    private SisterHospitallerEffect(SisterHospitallerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SisterHospitallerEffect copy() {
        return new SisterHospitallerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        int mv = card.getManaValue();
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        player.gainLife(mv, game, source);
        return true;
    }
}

