/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SithEvokerEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();

    public SithEvokerEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to that creature's power or toughness";
    }

    private SithEvokerEffect(SithEvokerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SithEvokerEffect copy() {
        return new SithEvokerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose mode");
            choice.setChoices(choices);
            if (!controller.choose(this.outcome, (Choice)choice, game)) {
                return false;
            }
            Card sourceCard = game.getCard(source.getSourceId());
            if (sourceCard != null) {
                for (Object cost : source.getCosts()) {
                    String chosen;
                    Permanent p;
                    if (!(cost instanceof SacrificeTargetCost) || (p = (Permanent)game.getLastKnownInformation(((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getId(), Zone.BATTLEFIELD)) == null) continue;
                    switch (chosen = choice.getChoice()) {
                        case "Gain life equal to creature's power": {
                            new GainLifeEffect(p.getPower().getValue()).apply(game, source);
                            break;
                        }
                        default: {
                            new GainLifeEffect(p.getToughness().getValue()).apply(game, source);
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    static {
        choices.add("Gain life equal to creature's power");
        choices.add("Gain life equal to creature's toughness");
    }
}

