/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.common.CanBeYourCommanderAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.abilities.effects.common.combat.CantAttackYouUnlessPayAllEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.common.TargetCardInLibrary;

public final class SivitriDragonMaster
extends CardImpl {
    private static final FilterCard filter = new FilterCard("a Dragon card");
    private static final FilterCreaturePermanent filterNonDragon = new FilterCreaturePermanent("non-Dragon creatures");

    public SivitriDragonMaster(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{2}{U}{B}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.SIVITRI);
        this.setStartingLoyalty(4);
        CantAttackYouUnlessPayAllEffect effect = new CantAttackYouUnlessPayAllEffect(Duration.UntilYourNextTurn, (Cost)new PayLifeCost(2), CantAttackYouUnlessPayAllEffect.Scope.YOU_AND_CONTROLLED_PLANESWALKERS);
        this.addAbility((Ability)new LoyaltyAbility((Effect)effect, 1));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filter), true), -3));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new DestroyAllEffect((FilterPermanent)filterNonDragon), -7));
        this.addAbility((Ability)CanBeYourCommanderAbility.getInstance());
    }

    private SivitriDragonMaster(SivitriDragonMaster card) {
        super((CardImpl)card);
    }

    public SivitriDragonMaster copy() {
        return new SivitriDragonMaster(this);
    }

    static {
        filter.add((Predicate)SubType.DRAGON.getPredicate());
        filterNonDragon.add(Predicates.not((Predicate)SubType.DRAGON.getPredicate()));
    }
}

