/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.FightTargetSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SkophosMazeWardenTriggeredAbility
extends TriggeredAbilityImpl {
    SkophosMazeWardenTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, true);
    }

    private SkophosMazeWardenTriggeredAbility(SkophosMazeWardenTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SkophosMazeWardenTriggeredAbility copy() {
        return new SkophosMazeWardenTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGETED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(stackObject.getSourceId());
        if (!(permanent != null && permanent.isControlledBy(this.getControllerId()) && permanent.isLand(game) && permanent.getName().equals("Labyrinth of Skophos"))) {
            return false;
        }
        Permanent creature = game.getPermanent(event.getTargetId());
        if (creature == null || !creature.isCreature(game) || creature.getId().equals(this.getSourceId())) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new FightTargetSourceEffect().setTargetPointer((TargetPointer)new FixedTarget(creature, game)));
        return true;
    }

    public String getRule() {
        return "Whenever another creature becomes the target of an ability of a land you control named Labyrinth of Skophos, you may have {this} fight that creature. <i>(Each deals damage equal to its power to the other.)</i>";
    }
}

